/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import dan200.computercraft.shared.util.RegistryHelper;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public final class SafeDispatchCodec<K, V>
extends MapCodec<V> {
    private static final String TYPE_KEY = "type";
    private static final String COMPRESSED_VALUE_KEY = "value";
    private final Codec<K> typeCodec;
    private final Function<V, K> type;
    private final Function<K, MapCodec<? extends V>> instanceCodec;

    private SafeDispatchCodec(Codec<K> typeCodec, Function<V, K> type, Function<K, MapCodec<? extends V>> instanceCodec) {
        this.typeCodec = typeCodec;
        this.type = type;
        this.instanceCodec = instanceCodec;
    }

    public static <K, V> Codec<V> codec(Codec<K> typeCodec, Function<V, K> type, Function<K, MapCodec<? extends V>> instanceCodec) {
        return new SafeDispatchCodec<K, V>(typeCodec, type, instanceCodec).codec();
    }

    public static <K, V> Codec<V> ofRegistry(ResourceKey<Registry<K>> typeRegistry, Function<V, K> type, Function<K, MapCodec<? extends V>> instanceCodec) {
        return SafeDispatchCodec.codec(Codec.lazyInitialized(() -> RegistryHelper.getRegistry(typeRegistry).byNameCodec()), type, instanceCodec);
    }

    public <T> DataResult<V> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object elementName = input.get(TYPE_KEY);
        if (elementName == null) {
            return DataResult.error(() -> "Input does not contain a key [type]: " + String.valueOf(input));
        }
        return this.typeCodec.decode(ops, elementName).flatMap(typeResult -> {
            DataResult result;
            Object type = typeResult.getFirst();
            MapCodec<? extends V> decoder = this.instanceCodec.apply(type);
            if (ops.compressMaps()) {
                Object value = input.get(ops.createString(COMPRESSED_VALUE_KEY));
                if (value == null) {
                    return DataResult.error(() -> "Input does not have a \"value\" entry: " + String.valueOf(input));
                }
                result = decoder.decoder().parse(ops, value);
            } else {
                result = decoder.decode(ops, input);
            }
            return result.flatMap(x -> {
                Object actualType = this.type.apply(x);
                if (actualType != type) {
                    return DataResult.error(() -> String.valueOf(x) + " has the incorrect type. Expected " + String.valueOf(type) + ", but was " + String.valueOf(actualType) + ".");
                }
                return DataResult.success((Object)x);
            });
        });
    }

    public <T> RecordBuilder<T> encode(V input, DynamicOps<T> ops, RecordBuilder<T> builder) {
        MapCodec<? extends V> encoder = this.instanceCodec.apply(this.type.apply(input));
        if (ops.compressMaps()) {
            return builder.add(TYPE_KEY, this.typeCodec.encodeStart(ops, this.type.apply(input))).add(COMPRESSED_VALUE_KEY, encoder.encoder().encodeStart(ops, input));
        }
        return encoder.encode(input, ops, builder).add(TYPE_KEY, this.typeCodec.encodeStart(ops, this.type.apply(input)));
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(TYPE_KEY, COMPRESSED_VALUE_KEY).map(arg_0 -> ops.createString(arg_0));
    }
}

