/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class RegistryHelper {
    private RegistryHelper() {
    }

    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> id) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(id.location());
        if (registry == null) {
            throw new IllegalArgumentException("Unknown registry " + String.valueOf(id));
        }
        return registry;
    }

    public static <T> ResourceLocation getKeyOrThrow(Registry<T> registry, T object) {
        Optional key = registry.getResourceKey(object);
        if (key.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(object) + " was not registered in " + String.valueOf(registry.key()));
        }
        return ((ResourceKey)key.get()).location();
    }
}

