/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface RegistryEntry<U>
extends Supplier<U> {
    public ResourceLocation id();

    public static <T> Codec<RegistryEntry<? extends T>> codec(Registry<T> registry) {
        return ResourceLocation.CODEC.flatXmap(id -> registry.getHolder(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)id)).map(x -> {
            record HolderEntry<T>(ResourceLocation id, Holder<T> holder) implements RegistryEntry<T>
            {
                @Override
                public T get() {
                    return (T)this.holder().value();
                }
            }
            return DataResult.success(new HolderEntry((ResourceLocation)id, x));
        }).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(registry.key()) + ": " + String.valueOf(id))), holder -> DataResult.success((Object)holder.id()));
    }
}

