/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.arguments;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dan200.computercraft.shared.util.RegistryHelper;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ArgumentUtils {
    public static <A extends ArgumentType<?>> JsonObject serializeToJson(ArgumentTypeInfo.Template<A> template) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "argument");
        object.addProperty("parser", RegistryHelper.getKeyOrThrow(BuiltInRegistries.COMMAND_ARGUMENT_TYPE, template.type()).toString());
        JsonObject properties = new JsonObject();
        ArgumentUtils.serializeToJson(properties, template.type(), template);
        if (properties.size() > 0) {
            object.add("properties", (JsonElement)properties);
        }
        return object;
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeToJson(JsonObject jsonObject, ArgumentTypeInfo<A, T> argumentTypeInfo, ArgumentTypeInfo.Template<A> template) {
        argumentTypeInfo.serializeToJson(template, jsonObject);
    }

    public static <A extends ArgumentType<?>> void serializeToNetwork(FriendlyByteBuf buffer, ArgumentTypeInfo.Template<A> template) {
        ArgumentUtils.serializeToNetwork(buffer, template.type(), template);
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeToNetwork(FriendlyByteBuf buffer, ArgumentTypeInfo<A, T> type, ArgumentTypeInfo.Template<A> template) {
        buffer.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getIdOrThrow(type));
        type.serializeToNetwork(template, buffer);
    }

    public static ArgumentTypeInfo.Template<?> deserialize(FriendlyByteBuf buffer) {
        ArgumentTypeInfo type = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byIdOrThrow(buffer.readVarInt());
        return type.deserializeFromNetwork(buffer);
    }

    public static Component getMessage(Message message) {
        MutableComponent mutableComponent;
        if (message instanceof Component) {
            Component component = (Component)message;
            mutableComponent = component;
        } else {
            mutableComponent = Component.literal((String)message.getString());
        }
        return mutableComponent;
    }

    public static Component getMessage(SimpleCommandExceptionType exception) {
        return ArgumentUtils.getMessage(exception.create().getRawMessage());
    }
}

