/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import dan200.computercraft.api.lua.Coerced;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Reflect {
    private static final Logger LOG = LoggerFactory.getLogger(Reflect.class);
    static final Type OPTIONAL_IN = Optional.class.getTypeParameters()[0];
    static final Type COERCED_IN = Coerced.class.getTypeParameters()[0];

    private Reflect() {
    }

    static @Nullable Class<?> getRawType(Member method, Type root, boolean allowParameter) {
        Type underlying = root;
        while (true) {
            if (underlying instanceof Class) {
                Class klass = (Class)underlying;
                return klass;
            }
            if (!(underlying instanceof ParameterizedType)) break;
            ParameterizedType type = (ParameterizedType)underlying;
            if (!allowParameter) {
                for (Type arg : type.getActualTypeArguments()) {
                    TypeVariable var;
                    if (arg instanceof WildcardType || arg instanceof TypeVariable && (var = (TypeVariable)arg).getName().startsWith("capture#")) continue;
                    LOG.error("Method {}.{} has generic type {} with non-wildcard argument {}.", new Object[]{method.getDeclaringClass(), method.getName(), root, arg});
                    return null;
                }
            }
            underlying = type.getRawType();
        }
        LOG.error("Method {}.{} has unknown generic type {}.", new Object[]{method.getDeclaringClass(), method.getName(), root});
        return null;
    }
}

