/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class ItemMapLikeRenderer {
    protected abstract void renderItem(PoseStack var1, MultiBufferSource var2, ItemStack var3, int var4);

    public void renderItemFirstPerson(PoseStack transform, MultiBufferSource render, int lightTexture, InteractionHand hand, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        Player player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        transform.pushPose();
        if (hand == InteractionHand.MAIN_HAND && player.getOffhandItem().isEmpty()) {
            this.renderItemFirstPersonCenter(transform, render, lightTexture, pitch, equipProgress, swingProgress, stack);
        } else {
            this.renderItemFirstPersonSide(transform, render, lightTexture, hand == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite(), equipProgress, swingProgress, stack);
        }
        transform.popPose();
    }

    private void renderItemFirstPersonSide(PoseStack transform, MultiBufferSource render, int combinedLight, HumanoidArm side, float equipProgress, float swingProgress, ItemStack stack) {
        Minecraft minecraft = Minecraft.getInstance();
        float offset = side == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        transform.translate(offset * 0.125f, -0.125f, 0.0f);
        if (!minecraft.player.isInvisible()) {
            transform.pushPose();
            transform.mulPose(Axis.ZP.rotationDegrees(offset * 10.0f));
            minecraft.getEntityRenderDispatcher().getItemInHandRenderer().renderPlayerArm(transform, render, combinedLight, equipProgress, swingProgress, side);
            transform.popPose();
        }
        transform.pushPose();
        transform.translate(offset * 0.51f, -0.08f + equipProgress * -1.2f, -0.75f);
        float f1 = Mth.sqrt((float)swingProgress);
        float f2 = Mth.sin((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * Mth.sin((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * Mth.sin((float)(swingProgress * (float)Math.PI));
        transform.translate(offset * f3, f4 - 0.3f * f2, f5);
        transform.mulPose(Axis.XP.rotationDegrees(f2 * -45.0f));
        transform.mulPose(Axis.YP.rotationDegrees(offset * f2 * -30.0f));
        this.renderItem(transform, render, stack, combinedLight);
        transform.popPose();
    }

    private void renderItemFirstPersonCenter(PoseStack transform, MultiBufferSource render, int combinedLight, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        Minecraft minecraft = Minecraft.getInstance();
        ItemInHandRenderer renderer = minecraft.getEntityRenderDispatcher().getItemInHandRenderer();
        float swingRt = Mth.sqrt((float)swingProgress);
        float tX = -0.2f * Mth.sin((float)(swingProgress * (float)Math.PI));
        float tZ = -0.4f * Mth.sin((float)(swingRt * (float)Math.PI));
        transform.translate(0.0f, -tX / 2.0f, tZ);
        float pitchAngle = renderer.calculateMapTilt(pitch);
        transform.translate(0.0f, 0.04f + equipProgress * -1.2f + pitchAngle * -0.5f, -0.72f);
        transform.mulPose(Axis.XP.rotationDegrees(pitchAngle * -85.0f));
        if (!minecraft.player.isInvisible()) {
            transform.pushPose();
            transform.mulPose(Axis.YP.rotationDegrees(90.0f));
            renderer.renderMapHand(transform, render, combinedLight, HumanoidArm.RIGHT);
            renderer.renderMapHand(transform, render, combinedLight, HumanoidArm.LEFT);
            transform.popPose();
        }
        float rX = Mth.sin((float)(swingRt * (float)Math.PI));
        transform.mulPose(Axis.XP.rotationDegrees(rX * 20.0f));
        transform.scale(2.0f, 2.0f, 2.0f);
        this.renderItem(transform, render, stack, combinedLight);
    }
}

