/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client;

import com.mojang.math.Transformation;
import dan200.computercraft.api.client.ModelLocation;
import dan200.computercraft.impl.client.ClientPlatformHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record TransformedModel(BakedModel model, Transformation matrix) {
    public TransformedModel(BakedModel model) {
        this(model, Transformation.identity());
    }

    public static TransformedModel of(ModelLocation location) {
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        return new TransformedModel(location.getModel(modelManager));
    }

    public static TransformedModel of(ModelResourceLocation location) {
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        return new TransformedModel(modelManager.getModel(location));
    }

    public static TransformedModel of(ResourceLocation location) {
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        return new TransformedModel(ClientPlatformHelper.get().getModel(modelManager, location));
    }

    public static TransformedModel of(ItemStack item, Transformation transform) {
        BakedModel model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(item);
        return new TransformedModel(model, transform);
    }
}

